//
//  GSIdentifiableParameter.h
//  GlyphsCore
//
//  Created by Martin Winter on 11.05.18.
//  Copyright © 2018 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NSString *GSParameterIdentifier;

@protocol GSIdentifiableParameter <NSObject>

/**
 Parameter objects contained in arrays, especially if there may be multiple instances of them, should return an identifier string. Its purpose is to identify parameters of the same type, independent of their array index. However, these identifiers are not intended to be unique for all instances. Callers requiring truly unique identifiers can use the return value to derive such identifiers.

 @return A string or nil if no identifier could be created.

 @see `GSParameterNodeGenerator`, `GSParameterNodeArrayController`
 */
- (nullable GSParameterIdentifier)parameterIdentifier;

@end

NS_ASSUME_NONNULL_END
